#include "nanovoid.h"

using namespace std;

/*
 * smch: should init the random seed in the very beginning, not init here
 * generate random number array a and bias b in init stage
 * a: normal distribution.  b: continuous uniform
 * */
void LocalitySensitiveHashing::lsh(valueType* v, uint wh, int* dest){
  valueType dot_sum = 0;
  valueType *a1 = a + wh*K*arr_len;
  valueType *b1 = b + wh*K;
  valueType *v1;
  uint k = 0, i = 0;
  for (; k < K; ++ k) {
    dot_sum = 0;
    v1 = v;
    for(i = 0; i < arr_len; ++i) {
      dot_sum += (*(v1++)) * (*(a1++)); //[wh*K*arr_len + arr_len*k + i];
    }
    *(dest++) = (int)floor(dot_sum + (*(b1++))); //[wh*K+k];
  }
}

LocalitySensitiveHashing::LocalitySensitiveHashing(int _seed, valueType _r, \
                                                   uint _K, uint _L, \
                                                   uint _arr_len) :
  seed(_seed), r(_r), K(_K), L(_L), arr_len(_arr_len), generator(_seed), nor_dis(0.0, 1.0), uni_dis(1.0)
{
  a = new valueType[arr_len * K * L];
  b = new valueType[K * L];
  uint i = 0;
  for(; i < arr_len * K * L; ++i) {
    a[i] = nor_dis(generator) / r;
  }
  for (i = 0; i < K * L; ++ i)
    b[i] = uni_dis(generator);
}

LocalitySensitiveHashing::~LocalitySensitiveHashing() {
  delete [] a;
  delete [] b;
}
